LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY shift IS    
  PORT( a, clk : IN std_logic;          
        b :  OUT std_logic); 
END shift; 

ARCHITECTURE gen_shift OF shift IS    
  COMPONENT dff        
    PORT( d, clk : IN std_logic;              
          q : OUT std_logic);    
  END COMPONENT;
    
  SIGNAL z : std_logic_vector( 0 TO 4 ); 
BEGIN    
  z(0) <= a;
   
  g1 : FOR i IN 0 TO 3 GENERATE        
    dffx : dff PORT MAP( z(i), clk, z(i + 1));    
  END GENERATE;
    
  b <= z(4); 
END gen_shift;




ARCHITECTURE long_way_shift OF shift IS    
  COMPONENT dff        
    PORT( d, clk : IN std_logic;              
          q : OUT std_logic);    
  END COMPONENT;
    
  SIGNAL z : std_logic_vector( 0 TO 4 ); 
BEGIN    
  z(0) <= a;
    
  dff1: dff PORT MAP( z(0), clk, z(1) );    
  dff2: dff PORT MAP( z(1), clk, z(2) );    
  dff3: dff PORT MAP( z(2), clk, z(3) );    
  dff4: dff PORT MAP( z(3), clk, z(4) );
     
  b <= z(4); 
END long_way_shift;

